library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity timer is
  
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(4 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0)
    );
end timer;

architecture rtl of timer is

 signal we,wl,wh,ws : std_logic;
 signal lo: unsigned(15 downto 0);
 signal hi: unsigned(15 downto 0);
 signal va : unsigned (31 downto 0);
 signal start: std_logic;
 signal re:std_logic;
 signal count:std_logic;
 

begin

  --Write signals
  --Style inspired by http://www.amazon.com/Embedded-SoPC-Design-Processor-Examples/dp/111800888X/ref=sr_1_3?s=books&ie=UTF8&qid=1332644132&sr=1-3
	we      <= '1' when chipselect = '1'and write ='1'  else '0' ;
	wl 		<= '1' when we ='1' and address = "00000"   else '0' ;
	wh 		<= '1' when we ='1' and address = "00001"   else '0' ;
	ws 		<= '1' when we ='1' and address = "00010"   else '0' ;
	re      <= '1' when chipselect = '1' and read='1'   else '0' ;
readdata <= 
	va(15 downto 0) when address="00000" and re ='1' else
	va(31 downto 16) when address="00001" and re ='1' else
	x"0000";



process(clk)
begin
if rising_edge(clk) then
    
	va <= va;
	start   <=  start; 
 
	if reset_n='0' then
		count <= '0' ;
		start <='0';
	end if;

	if wh = '1' then va(31 downto 16) 		<= writedata;
    elsif wl = '1' then va(15 downto 0)  <= writedata ;
	elsif ws = '1' then start <= writedata(0);
	else
	if start ='1' then 
		count <= '1';
		start <= '0' ;
		end if;
	if count ='1' then
	   
	  if va = x"00000000" then 
	count <= '0' ; start <= '0' ; 
	else 
	va <= va - 1;
	end if;
	  
	
	end if;
end if;
end if;
end process;



end rtl;